#include <iostream>
#include <string>
#include <sstream>
#include <fstream>
#include <vector>
#include <iomanip>

#include "testers.h"
#include "fen.h"
#include "log.h"

using namespace std;

cTester::cTester()
{
    inputfilename = "noinputfile.dat";
    outputfilename = "nooutputfile.dat";
    timeperposition = 0;
}
//using mirror.epd, 160k positions
void cTester::evalmirror()
{
    string line;
    int quit=0;
    int ev1,ev2;
    int num=0;
    ifile.open(inputfilename.c_str());
    if(!(ifile.is_open())) {cout<<"\n file not found"; return;}

    while (!ifile.eof() )
    {
      getline (ifile,line);
      if(num%10000==0) cout<<"\n ---> "<<num;
      setepdposition(line.c_str(),tree.game,tree.mat,tree.his);
      ev1=tree.scorer.eval(tree.game,tree.mat,tree.ptab);
      mirrorboard(tree.game,tree.mat,tree.his);
      ev2=tree.scorer.eval(tree.game,tree.mat,tree.ptab);
      if(ev1!=ev2)
      {
          cout << "\n fail !! ev1: "<<ev1<<" ev2: "<<ev2;
          cout<<"\nPosition epd  "<<line<<endl;
          cout<<"\n position number "<<num;
          cout<<"\n Enter 1 to quit, any number to go on... -->";
      cin>>quit;
      if(quit==1) break;
      }
      num++;
    }
    ifile.close();

    cout<<"\n Mirror Eval Test Complete ";
    cout<<endl;
    return;
}


struct sBenchres
{
    double nulltry,nullcuts;
    double qnodes,nodes;
    double fh,fhf;
    double time;
};

void cumulate(sBenchres &cum, sBenchres entry)
{
    cum.nulltry += entry.nulltry;
    cum.nullcuts += entry.nullcuts;
    cum.qnodes += entry.qnodes;
    cum.nodes += entry.nodes;
    cum.fh += entry.fh;
    cum.fhf += entry.fhf;
    cum.time += entry.time;
}

void cTester::benchmark()
{

    vector<sBenchres> results;
    sBenchres storeme;
    sBenchres cumulative;

    double start = double(clock());

    memset(&cumulative, 0, sizeof(sBenchres));

    if(logger.islog())
    {
        logger.file<<"Benchmark test, inputfile <"<<inputfilename<<">";
        logger.file<<" outputfile <"<<outputfilename<<">";
        if(depthset!=0) logger.file<<" depth set to "<<depthset<<endl;
        else logger.file<<" movetime set to "<<timeperposition<<endl;
    }

    cout<<"Benchmark test, inputfile <"<<inputfilename<<">";
    cout<<" outputfile <"<<outputfilename<<">";
    if(depthset!=0) cout<<" depth set to "<<depthset<<endl;
    else cout<<" movetime set to "<<timeperposition<<endl;

    tree.setmode(smNONE);
    string line;
    int num=0;
    ifile.open(inputfilename.c_str());
    ofile.open(outputfilename.c_str());
    if(!(ifile.is_open())) {cout<<"\n file not found"; return;}

    while (!ifile.eof() )
    {
      getline (ifile,line);
      tree.timer.resettimeparam(cW);
      tree.timer.resettimeparam(cB);
      if(depthset!=0)
      {
          ASS(timeperposition==0);
          tree.timer.setdepth(depthset);
          tree.timer.setmodetpm(false);
          tree.timer.setmodemtg(false);
          tree.timer.setdepthlimit(true);
      }
      else
      {
	   tree.timer.settimepermove(timeperposition);
       tree.timer.setmodetpm(true);
      }
      setepdposition(line.c_str(),tree.game,tree.mat,tree.his);
      tree.compute();
      tree.timer.print_time_elapsed();
      storeme.fh = tree.getstats()[0].fh;
      storeme.fhf = tree.getstats()[0].fhf;
      storeme.nulltry = tree.getstats()[0].nulltry;
      storeme.nullcuts = tree.getstats()[0].nullcuts;
      storeme.nodes = tree.getdata()[0].nodes;
      storeme.qnodes = tree.getdata()[0].qnodes;
      storeme.time = (double)tree.timer.time_elapsed();
      results.push_back(storeme);
      cumulate(cumulative,storeme);
      num++;
    }

    ifile.close();

    cout<<"\n num positions = "<<results.size();
    cout<<"\n total time = "<<cumulative.time;
    cout<<"\n total nodes = "<<cumulative.qnodes+cumulative.nodes;
    cout<<"\n nps = "<<((cumulative.qnodes+cumulative.nodes)/((cumulative.time)/1000))<<"nps\n";

    uint i;

    for(i = 0; i < results.size(); ++i)
    {
        ofile<<"\npos,"<<(i+1)<<",fh,"<<results[i].fh<<",fhf,"<<results[i].fhf;
        ofile<<","<<percent(int(results[i].fhf),int(results[i].fh+results[i].fhf))<<",%";
        ofile.flush();
    }
    ofile<<"\nTotal,->,fh,"<<cumulative.fh<<",fhf,"<<cumulative.fhf;
    ofile<<","<<percent(int(cumulative.fhf),int(cumulative.fh+cumulative.fhf))<<",%";

    for(i = 0; i < results.size(); ++i)
    {
        ofile<<"\npos,"<<i+1<<",nodes,"<<results[i].nodes<<",qnodes,"<<results[i].qnodes;
        ofile<<","<<percent(int(results[i].qnodes),int(results[i].nodes+results[i].qnodes))<<",%qnodes";
        ofile.flush();
    }
    ofile<<"\nTotal,->,qnodes,"<<cumulative.qnodes<<",nodes,"<<cumulative.nodes;
    ofile<<","<<percent(int(cumulative.qnodes),int(cumulative.qnodes+cumulative.nodes))<<",%";

    for(i = 0; i < results.size(); ++i)
    {
        ofile<<"\npos,"<<(i+1)<<",nulltry,"<<results[i].nulltry<<",nullcuts,"<<results[i].nullcuts;
        ofile<<","<<percent(int(results[i].nullcuts),int(results[i].nulltry+results[i].nullcuts))<<",%";
        ofile.flush();
    }
    ofile<<"\nTotal,->,nulltry,"<<cumulative.nulltry<<",nullcuts,"<<cumulative.nullcuts;
    ofile<<","<<percent(int(cumulative.nullcuts),int(cumulative.nulltry+cumulative.nullcuts))<<",%";
    ofile<<"Total time "<<((double(clock())-start)/1000)<<"s"<<endl;
    ofile.close();

    if(logger.islog())
    {
         logger.file<<"Total time "<<((double(clock())-start)/1000)<<"s"<<endl;
         logger.file<<"\n\n-----------------> Benchmark Test Complete <-------------------";
         logger.file.flush();
    }

    cout<<"\n Benchmark Test Complete ";
    cout<<endl;

    return;
}

/*
manual usage - setting are changed by hand in the function

function is for testing the relationship between different eval
parameters on move ordering
*/

//-regress-i benchmark.epd -o reg.txt -t 3
void cTester::regress()
{

    double cfh,cfhf;
    cfh=cfhf=0;
    tree.setmode(smNONE);
    string line;
    ofile.open(outputfilename.c_str());

    vector<string> positions;
    ifile.open(inputfilename.c_str());
    if(!(ifile.is_open())) {cout<<"\n file not found"; return;}
    while (!ifile.eof() )
    {
      getline (ifile,line);
      positions.push_back(line);
      cout<<line<<endl;
    }
       ifile.close();


    int step,x;
    int min = -128; //0,5cp


 for(min = -64; min <= -16; min+=16)
 {
  for(step = 8; step <= 32; step += 8)
  {
     cout<<"\n MIN --> "<<min;
     cout<<"\n STEP --> "<<step;
     tree.scorer.knightmobmax = step;
     tree.scorer.knightmobmin = min;
     tree.scorer.init_mobility();
     ofile<<"\n\n NMob settings ";
     for(x = 0; x < 8; ++x) ofile<<","<<tree.scorer.knightmob[x];
     //ofile<<endl;
     cout<<"\n\n NMob settings ";
     for(x = 0; x < 8; ++x) cout<<","<<tree.scorer.knightmob[x];
     cout<<endl;
   // test loop
   cfh=0;cfhf=0;
   for(x = 0; x < positions.size(); ++x)
    {
      tree.timer.resettimeparam(cW);
      tree.timer.resettimeparam(cB);
	  tree.timer.settimepermove(timeperposition);
      tree.timer.setmodetpm(true);
      tree.ttable.reset_tables();
      setepdposition(positions[x].c_str(),tree.game,tree.mat,tree.his);
      tree.compute();
      cfh += tree.getstats()[0].fh;
      cfhf += tree.getstats()[0].fhf;
    }
   ofile<<",fh,"<<cfh<<",fhf,"<<cfhf;
   ofile<<","<<percent(int(cfhf),int(cfh+cfhf))<<",%";
   ofile.flush();
   // test loop end
  }
 }

    cout<<"\n Reg Test Complete ";
    cout<<endl;

    if(logger.islog())
    {
         logger.file<<"\n\n-----------------> Reg Test Complete <-------------------";
         logger.file.flush();
    }
    return;
}

//each epd line is broken down into the fen string and the best moves,
//to be stored in the sEpdline structure

#define TYPEBM 1
#define TYPEAM 2

struct sEpdline {
    string fen;
    vector<string> bestmove;
    int type;
};

struct sTestResults {
    double solved;
    double notsolved;
    vector<bool> success;
    vector<string> ourmove;
    vector<uint> ourintmove;
};

void cTester::epdtest()
{
    cout<<"\n called epdtest";
    string line;

    if(logger.islog()) logger.file<<"EPD TESTING ACTIVE\n";

    //read in the epd file into a vector
    vector<string> positions;
    ifile.open(inputfilename.c_str());
    if(!(ifile.is_open())) {cout<<"\n file not found"; return;}
    while (!ifile.eof() )
    {
      getline (ifile,line);
      if(line.length() < 29)
      {
          cout<<"\n bad position ? <"<<line<<">";
      }
      else
      {
          positions.push_back(line);
      }
    }
    ifile.close();

    //tokenize epd lines by spaces
    vector<string> tokenized;
    string tempfen;
    sEpdline entry;
    uint index;
    uint index2;
    int type;
    size_t finder;
    vector<sEpdline> testdata;

    bool foundbest=false;
    for(index = 0; index < positions.size(); ++index)
    {
        type=0;
        tokenized.clear();
        tempfen.clear();
        entry.fen.clear();
        entry.bestmove.clear();

        stringsplitter(positions[index], ' ', tokenized);
        index2 = 0;

        foundbest=false;
        while(tokenized[index2]!="bm" && tokenized[index2]!="am")
        {
           tempfen+=tokenized[index2];
           tempfen+=' ';
           index2++;
        }
        entry.fen = tempfen;

        ASS(tokenized[index2]=="bm" || tokenized[index2]=="am");
        foundbest=true;

        if(tokenized[index2]=="bm") type = TYPEBM;
        else if(tokenized[index2]=="am") type = TYPEAM;

        if(!type) cout<<"\n bestmove not found -> "<<positions[index];

        entry.type = type;
        /*
        so, tempfen holds the fen leading up to "bm"
        now need to loop index2++ until we find a ';' meaning the last of the best moves
        */

        index2++;
        while((finder = tokenized[index2].find(';')) == string::npos)
        {
            entry.bestmove.push_back(tokenized[index2]);
            index2++;
            finder = tokenized[index2].find(';');
        }

        tokenized[index2].erase(tokenized[index2].length()-1);//take off ';'
        entry.bestmove.push_back(tokenized[index2]);

        testdata.push_back(entry);

    }

    if(logger.islog()) logger.file<<"EPD file read in : <"<<inputfilename<<">\n";

    tokenized.clear();
    positions.clear();

    /*
    now the actual testing part....
    */
    cout<<"***************EPD LOADED************";
    cout<<"\n "<<testdata.size()<<" test positions in total ";
    if(logger.islog()) logger.file<<"testing "<<testdata.size()<<" test positions in total ";

    tree.setmode(smNONE);

    string ourbest;
    sTestResults results;
    results.solved = 0;
    results.notsolved = 0;
    results.success.clear();
    bool success = false;
    for(index = 0; index < testdata.size(); ++index)
    {
      success=false;
      line.clear();
      ourbest.clear();
      line = testdata[index].fen;
      tree.timer.resettimeparam(cW);
      tree.timer.resettimeparam(cB);
	  tree.timer.settimepermove(timeperposition);
      tree.timer.setmodetpm(true);
      setepdposition(line.c_str(),tree.game,tree.mat,tree.his);
      cout<<"\n"<<outputfilename<<" position "<<index<<"\nfen: "<<line;
      tree.compute();
      tree.timer.print_time_elapsed();
      ourbest = movetosan(tree.getbestmove(), tree.game, tree.mat, tree.his);
      type = testdata[index].type;
       for(index2 = 0; index2 < testdata[index].bestmove.size(); ++index2)
       {
            if(type==TYPEBM && ourbest==testdata[index].bestmove[index2])success = true;
            else if(type==TYPEAM && ourbest!=testdata[index].bestmove[index2])success = true;
       }

       if(logger.islog()) logger.file<<" "<<outputfilename<<" position "<<index;
       if(success)
       {
           cout<<"\n SOLVED :)";
           if(logger.islog()) logger.file<<" SOLVED :) \n";
           results.solved++;
       }
       else
       {
           cout<<"\n NOT SOLVED :(";
           if(logger.islog()) logger.file<<" NOT SOLVED :( \n";
           results.notsolved++;
       }
       results.success.push_back(success);
       results.ourmove.push_back(ourbest);
       results.ourintmove.push_back(tree.getbestmove());
       cout<<"\n\n So Far: "<<results.solved<<" solved from "<<results.success.size();
       cout<<" "<<percent((int)results.solved, (int)results.success.size())<<"%";

       if(logger.islog())
       {
           logger.file<<"So Far: "<<results.solved<<" solved from "<<results.success.size();
           logger.file<<" "<<percent((int)results.solved, (int)results.success.size())<<"%\n";
           logger.file.flush();
       }

    }

    /*
    EPD test is over, now write the results to screen and file...
    */
    if(logger.islog()) logger.file<<"EPD testing over, writing result file ";
    ofile.open(outputfilename.c_str());

    ASS(testdata.size()==results.success.size());
    ofile<<"EPD file : <"<<inputfilename<<">\n";

    for(index = 0; index < results.success.size(); ++index)
    {
        cout<<"\nPosition "<<index<<" ";
        if(results.success[index]) cout<<" PASS ";
        else
        {
            cout<<" FAIL ";
            if(testdata[index].type==TYPEBM) cout<<" bm ";
            else if(testdata[index].type==TYPEAM) cout<<" am ";
            for(index2 = 0; index2 < testdata[index].bestmove.size(); ++index2)
            {
             cout<<testdata[index].bestmove[index2]<<" ";
            }
            cout<<" ourmove "<<results.ourmove[index];
            cout<<" ("<<printmove(results.ourintmove[index])<<") ";
        }
        cout<<testdata[index].fen<<" ";
    }

    cout<<"\n Total "<<results.solved<<" solved from "<<results.notsolved+results.solved;
    cout<<" "<<percent((int)results.solved, (int)results.success.size())<<"%";

    for(index = 0; index < results.success.size(); ++index)
    {
        ofile<<"\nPosition "<<index<<" ";
        if(results.success[index]) ofile<<" PASS ";
        else
        {
            ofile<<" FAIL ";
            if(testdata[index].type==TYPEBM) ofile<<" bm ";
            else if(testdata[index].type==TYPEAM) ofile<<" am ";
            for(index2 = 0; index2 < testdata[index].bestmove.size(); ++index2)
            {
             ofile<<testdata[index].bestmove[index2]<<" ";
            }
            ofile<<" ourmove "<<results.ourmove[index];
            ofile<<" ("<<printmove(results.ourintmove[index])<<") ";
        }
        ofile<<testdata[index].fen<<" ";
    }

    ofile<<"\n Total "<<results.solved<<" solved from "<<results.notsolved+results.solved;
    ofile<<" "<<percent((int)results.solved, (int)results.success.size())<<"%";

    //for excel sheet transfer

    ofile<<"\n EXCEL LIST : \n";
    for(index = 0; index < results.success.size(); ++index)
    {
        if(results.success[index]) ofile<<"PASS\n";
        else ofile<<"FAIL\n";
    }


    ofile.close();

    if(logger.islog())
    {
         logger.file<<"\n\n-----------------> EPD Test Complete <-------------------";
         logger.file.flush();
    }

    cout<<endl;
}

